<?php
if (isset($semRefrescamento)) {
	include_once '../modelo/respostaEntrevista.modelo.php';
	include_once 'resposta.controlador.php';
	include_once 'pergunta.controlador.php';
}else {
	include_once 'modelo/respostaEntrevista.modelo.php';
	include_once 'resposta.controlador.php';
	include_once 'pergunta.controlador.php';
} 
	
  
class ControladorRespostaEntrevista
{
 
static public function ctrAddRespostaEntrevista($idResposta)
{
  
	if (!empty($idResposta)) 
	{
				$idVaga = addslashes($_SESSION["idVaga"]);
				$idResposta = addslashes($idResposta);
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = addslashes($_SESSION['ID_usuario']);
				
				$dados = array("idResposta" => filter_var($idResposta,FILTER_SANITIZE_STRIPPED),
				"idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED), 
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED));

				 $verifExistencia = ControladorRespostaEntrevista::ctrVerificarRespostaJaFoidadaPeloUsuarioNaEntrevista($idResposta,$idVaga,$idUsuario);
				if ($verifExistencia == true) 
				{ 
					$resposta = ModeloRespostaEntrevista:: mdlAddRespostaEntrevista($dados);

					if($resposta == "ok"){
						$_SESSION["numRespostaActual"] = $_SESSION["numRespostaActual"] + 1;
							 
					}else{
						/* echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi possivel cadastrar a respostas',
								showConfirmButton: false,
								timer: 5000
							})
						</script>"; */
						
					}
				 }else
				{
					/* echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi possivel cadastrar Porque esta Resposta já foi dada',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					"; */
				} 

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}	


}

static public function ctrAddRespostaAvaliacao($idResposta)
{
 
	if (!empty($idResposta)) 
	{			
				$idTema = addslashes($_SESSION["avaliacao"]);
				$idVaga = addslashes($_SESSION["idVaga"]);
				$idResposta = addslashes($idResposta);
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = addslashes($_SESSION['ID_usuario']);
				
				$dados = array("idResposta" => filter_var($idResposta,FILTER_SANITIZE_STRIPPED),
				"idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED), 
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED), 
				"idTema" => filter_var($idTema,FILTER_SANITIZE_STRIPPED));

				 $verifExistencia = ControladorRespostaEntrevista::ctrVerificarRespostaDaAvaliacaoJaFoidadaPeloUsuarioNaEntrevista($idResposta,$idVaga,$idUsuario,$idTema);
				if ($verifExistencia == true) 
				{ 
					$resposta = ModeloRespostaEntrevista::mdlAddRespostaAvaliacao($dados);

					if($resposta == "ok"){
						$_SESSION["numRespostaActual"] = $_SESSION["numRespostaActual"] + 1;
							/*  echo"
					<script>
					Swal.fire({ 
						position: 'top-end',
						icon: 'success',
						title: 'Resposta Cadastrado com sucesso!',
						showConfirmButton: false,
						timer: 5000
					})
					</script> 
					"; 	 */
					}else{
						echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi possivel cadastrar a respostas',
								showConfirmButton: false,
								timer: 5000
							})
						</script>";
						
					}
				 }else
				{
					/* echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi possivel cadastrar Porque esta Resposta já foi dada',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					"; */
				} 

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}	


}


static public function ctrVerificarRespostaJaFoidadaPeloUsuarioNaEntrevista($idResposta,$idVaga,$idCandidato){

	$resposta = ModeloRespostaEntrevista::mdlMostrarRespostasPorIdCandidatoEidVagaEIdResposta($idResposta,$idVaga,$idCandidato);
	if (empty($resposta)) {
		return true;
	}
	else {
		return false;
	}
}



static public function ctrVerificarRespostaDaAvaliacaoJaFoidadaPeloUsuarioNaEntrevista($idResposta,$idVaga,$idCandidato,$idTema){

	$resposta = ModeloRespostaEntrevista::mdlMostrarRespostasAvaliacaoPorIdCandidatoEidVagaEIdRespostaEIdTema($idResposta,$idVaga,$idCandidato,$idTema);
	if (empty($resposta)) {
		return true;
	}
	else {
		return false;
	}
}

  
static public function ctrMostrarTodosEquipamentos(){

	$resposta = ModeloEquipamento::mdlMostrarTodosEquipamentos();
	return $resposta;
	
}



static public function ctrOrdenaridRespostasPorOrdemCrescente($idVaga){
	$resposta = ModeloidResposta::mdlMostrarTodasAsidRespostasDaVagaPoridVaga($idVaga);
	if (empty($resposta[count($resposta)-1]["ordem"]) || $resposta[count($resposta)-1]["ordem"] == "") {
		return 0;
	}else {
		return $resposta[count($resposta)-1]["ordem"];
	}
	
}

static public function ctrMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	return $resposta;
} 

static public function ctrMostrarTodasAsRespostasDoEstudanteNaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasDaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema);
	return $resposta;
}

static public function ctrContarTodasAsRespostasDoEstudanteNaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasDaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema);
	return count($resposta);
}

static public function ctrMostrarIdDaRespostaPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]);
	}
	
}

static public function ctrMostrarPontosDoCandidatoPorIdCandidatoEidVaga($idVaga,$idCandidato){
	$postos = 0;
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	foreach ($resposta as $key => $value) {
		$dadoResposta = ControladorResposta::ctrMostrarRespostaPorIdResposta($value["idResposta"]);
		if (!empty($dadoResposta)) {
			$postos = $postos + $dadoResposta[0]["pontuacao"];
		}
		
	}
	return $postos;
	
}

static public function ctrMostrarPontosDoCandidatoNaAvaliacaoPorIdCandidatoEidVaga($idVaga,$idCandidato, $idTema){
	$postos = 0;
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasDaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema);
	foreach ($resposta as $key => $value) {
		$dadoResposta = ControladorResposta::ctrMostrarRespostaPorIdResposta($value["idResposta"]);
		if (!empty($dadoResposta)) {
			$postos = $postos + $dadoResposta[0]["pontuacao"];
		}
		
	}
	return $postos;
	
}

static public function ctrMostrarOrdemDaPerguntaActual($idVaga,$idCandidato){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorPergunta::ctrMostrarOrdemDaPergunta(ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]));
	}	 
}

static public function ctrMostrarOrdemDaPerguntaActualDaAvaliacao($idVaga,$idCandidato, $idTema){
	$resposta = ModeloRespostaEntrevista::mdlMostrarTodasAsRespostasDaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema);
	if (empty($resposta[count($resposta)-1]["idResposta"]) || $resposta[count($resposta)-1]["idResposta"] == "") {
		return 0;
	}else {
		return ControladorPergunta::ctrMostrarOrdemDaPergunta(ControladorResposta::ctrMostrarOIdDaPerguntaDestaRespostaPorIdResposta($resposta[count($resposta)-1]["idResposta"]));
	}
	 
}




static public function ctrMostrarDadosDoUsuarioPorID($id){

		$resposta = ModeloUsuario::mdlMostrarDadosDoUsuarioPorID(addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarDadosUsuario($nome, $bi_nif,$sexo, $email,$id,$senha){

		$resposta = ModeloUsuario::mdlActualizarDadosUsuario(addslashes($nome), addslashes($bi_nif), addslashes($sexo), addslashes($email),addslashes($id),md5(addslashes($senha)));

		return $resposta;

	}
 
	static public function ctrActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso, $id){  

		$resposta = ModeloUsuario::mdlActualizarDadosUsuarioprofessors(addslashes($nome), addslashes($bi_nif), addslashes($nivelDeAcesso),addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarImagemPerfilUsuario($imagem,$id){

		$resposta = ModeloUsuario::mdlActualizarImagemPerfilUsuario($imagem,addslashes($id));

		return $resposta;

	}

	static public function ctrActualizarCodigoParaReporSenha($idUsuario, $codigo){

		$resposta = ModeloUsuario::mdlActualizarCodigoParaReporSenha($idUsuario, $codigo);
		return $resposta;

	}
 
	static public function ctrActualizarSenhaUsuario($senhaAntiga,$id, $senha){

		$resposta = ModeloUsuario::mdlActualizarSenhaUsuario(addslashes($senhaAntiga),addslashes($id), md5(addslashes($senha)));
		return $resposta;

	}

	static public function ctrActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$resposta = ModeloUsuario::mdlActualizarReporSenhaUsuario(md5(addslashes($senha)),$id,$codigoParaReporSenha);
		return $resposta;

	}

	static public function ctrDeletarUsuario($id){

		$resposta = ModeloUsuario::mdlDeletarUsuario(addslashes($id));
		return $resposta;

	}

}

?>